-- =============================================
-- UPDATE CART VIEW - Toko Baju Junata
-- Run this SQL to fix cart display issues
-- =============================================

USE junata_db;

-- Drop and recreate cart view with correct column names
DROP VIEW IF EXISTS v_cart_details;

CREATE VIEW v_cart_details AS
SELECT 
    c.id AS cart_id,
    c.user_id,
    c.product_id,
    c.quantity,
    p.nama AS nama_produk,
    p.deskripsi,
    p.harga,
    p.stok,
    p.kategori,
    p.gambar,
    (c.quantity * p.harga) AS subtotal,
    c.created_at
FROM carts c
INNER JOIN products p ON c.product_id = p.id;

-- Verify the view was created successfully
SELECT 'Cart view updated successfully!' AS status;

-- Test the view (will show cart items if any exist)
SELECT * FROM v_cart_details LIMIT 5;
